using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This exception is thrown when VistALink message XML (or XML that is 
	/// supposed to be a source for VistALink message XML) cannot be validated
	/// against the specified XSD.
	/// </summary>
	public class VistALinkMessageXmlVsXsdValidationException : VistALinkException
	{
		/// <summary>
		/// Default parameterless constructor. Should be avoided whenever possible.
		/// </summary>
		public VistALinkMessageXmlVsXsdValidationException() : 
			base(){}

		/// <summary>
		/// This constructor allows specifying an error message upon throwing an exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		public VistALinkMessageXmlVsXsdValidationException( string message ) : 
			base( message ){}

		/// <summary>
		/// This constructor allows adding inner exception that caused this exception.
		/// </summary>
		/// <param name="message">Human-readable message describing the error.</param>
		/// <param name="inner">Inner exception that caused this exception.</param>
		public VistALinkMessageXmlVsXsdValidationException( string message, Exception inner ) : 
			base( message, inner ){}
	}
}
